//%attributes = {"publishedSql":true}
// Method: _bc_ Code128Encode
// 2004.11.18-16:31:41 / Pasi Mankinen
// © Copyright 2004 Manage Applications
// Purpose: 
// checksum calculation and text conversion of Code128 bar code
// handes types A,B,C and combinations of them
// ------------------------------------------------------------
C_LONGINT:C283($_bc_lErrCode)
C_TEXT:C284($0; $1; $_bc_tSource; $2; $_bc_tParamTypes)
C_TEXT:C284($_bc_tResult; $_bc_tType; $_bc_tCodeCCombined)
C_LONGINT:C283($_bc_lTypeChar; $_bc_lPrevTypeChar; $_bc_lResultIndex; $_bc_lTypeLength; $_bc_lStart; $_bc_lEnd; $_bc_lCharIndex)
C_LONGINT:C283($_bc_lParamIndex; $_bc_lLoopIndex; $_bc_lSourceAscii; $_bc_lSourceLength; $_bc_lCodeCValue; $_bc_lCheckNum)

$_bc_tSource:=$1
$_bc_tParamTypes:=_str_ ToUpper($2)
$_bc_lPrevTypeChar:=0
$_bc_tCodeCCombined:=""

$_bc_lSourceLength:=Length:C16($_bc_tSource)
$_bc_tResult:=($_bc_lSourceLength+4+Length:C16($_bc_tParamTypes))*" "
//+4 = start + check + stop + termination bar 
//+ possible type changes
//absolutely max length, reserve space for result already here

$_bc_lResultIndex:=0
$_bc_lLoopIndex:=0
$_bc_lParamIndex:=0
$_bc_lStart:=1

_bc_CODE128_CHARS_LOAD
$_bc_tSource:=_bc_ AsciiChange(kEncode; $_bc_tSource)

Repeat 
	$_bc_lLoopIndex:=$_bc_lLoopIndex+1
	
	$_bc_lParamIndex:=$_bc_lParamIndex+1
	$_bc_tType:=_str Parse($_bc_tParamTypes; ","; $_bc_lParamIndex)
	$_bc_lParamIndex:=$_bc_lParamIndex+1
	If (Length:C16($_bc_tType)>0)
		
		$_bc_lTypeLength:=Num:C11(_str Parse($_bc_tParamTypes; ","; $_bc_lParamIndex))
		If ($_bc_lTypeLength<=0)
			$_bc_lTypeLength:=$_bc_lSourceLength-$_bc_lStart+1
		End if 
		If ($_bc_lSourceLength<($_bc_lStart+$_bc_lTypeLength))
			$_bc_lTypeLength:=$_bc_lSourceLength-$_bc_lStart+1  //PM: 2005-02-04, fix for code length
		End if 
		$_bc_lTypeChar:=Character code:C91($_bc_tType[[1]])
		$_bc_lEnd:=$_bc_lStart+$_bc_lTypeLength-1  //PM: 2005-02-04, fix for code length
		
		Case of   //main type case
			: ($_bc_lTypeChar=Character code:C91("A"))  //type A
				Case of 
					: ($_bc_lLoopIndex=1)
						$_bc_lResultIndex:=$_bc_lResultIndex+1
						$_bc_tResult[[$_bc_lResultIndex]]:=Char:C90(141)  //Start A
					: ($_bc_lPrevTypeChar#$_bc_lTypeChar)
						$_bc_lResultIndex:=$_bc_lResultIndex+1
						$_bc_tResult[[$_bc_lResultIndex]]:=Char:C90(136)  // ShiftToA
				End case 
				
				For ($_bc_lSourceIndex; $_bc_lStart; $_bc_lEnd)
					// loop through find str
					$_bc_lSourcestring:=Character code:C91($_bc_tSource[[$_bc_lSourceIndex]])
					Case of 
						: ($_bc_lSourceAscii=32)  // Space 
							$_bc_lResultIndex:=$_bc_lResultIndex+1
							$_bc_tResult[[$_bc_lResultIndex]]:=Char:C90(148)  // space -> î
						: ($_bc_lSourceAscii=31)  // 31+96=127=DEL
							$_bc_lResultIndex:=$_bc_lResultIndex+1
							$_bc_tResult[[$_bc_lResultIndex]]:=Char:C90(149)  // del -> ï 
						: ($_bc_lSourceAscii<31)  //low ascii
							$_bc_lResultIndex:=$_bc_lResultIndex+1
							$_bc_tResult[[$_bc_lResultIndex]]:=Char:C90($_bc_lSourceAscii+96)  //other low ascii     
							//in code A: ascii(0)=NUL -> `, ascii(1)=SOH -> a
						Else   //normal ascii
							$_bc_lCharIndex:=Find in array:C230(<>_bc_alCode128_Ascii; $_bc_lSourceAscii)
							If ($_bc_lCharIndex>0)
								$_bc_lResultIndex:=$_bc_lResultIndex+1
								$_bc_tResult[[$_bc_lResultIndex]]:=$_bc_tSource[[$_bc_lSourceIndex]]
							Else 
								_err MESSAGE(_lang Current("Type A character not found from character array"); Current method name:C684; kFalse)
							End if 
					End case 
				End for 
				
			: ($_bc_lTypeChar=Character code:C91("B"))  //type B
				Case of 
					: ($_bc_lLoopIndex=1)
						$_bc_lResultIndex:=$_bc_lResultIndex+1
						$_bc_tResult[[$_bc_lResultIndex]]:=Char:C90(144)  // BStart
					: ($_bc_lPrevTypeChar#$_bc_lTypeChar)
						$_bc_lResultIndex:=$_bc_lResultIndex+1
						$_bc_tResult[[$_bc_lResultIndex]]:=Char:C90(138)  //ShiftToB
				End case 
				
				For ($_bc_lSourceIndex; $_bc_lStart; $_bc_lEnd)
					// loop through find str
					$_bc_lSourceAscii:=Character code:C91($_bc_tSource[[$_bc_lSourceIndex]])
					Case of 
						: ($_bc_lSourceAscii=32)  // Space 
							$_bc_lResultIndex:=$_bc_lResultIndex+1
							$_bc_tResult[[$_bc_lResultIndex]]:=Char:C90(148)  // space -> î
						: ($_bc_lSourceAscii=127)  // code B DEL
							$_bc_lResultIndex:=$_bc_lResultIndex+1
							$_bc_tResult[[$_bc_lResultIndex]]:=Char:C90(149)  // del -> ï           
						Else   //normal ascii
							$_bc_lCharIndex:=Find in array:C230(<>_bc_alCode128_Ascii; $_bc_lSourceAscii)
							If ($_bc_lCharIndex>0)
								$_bc_lResultIndex:=$_bc_lResultIndex+1
								$_bc_tResult[[$_bc_lResultIndex]]:=$_bc_tSource[[$_bc_lSourceIndex]]
							Else 
								_err MESSAGE(_lang Current("Type B character not found from character array"); Current method name:C684; kFalse)
							End if 
					End case 
				End for 
				
			: ($_bc_lTypeChar=Character code:C91("C"))  //type C
				Case of 
					: ($_bc_lLoopIndex=1)
						$_bc_lResultIndex:=$_bc_lResultIndex+1
						$_bc_tResult[[$_bc_lResultIndex]]:=Char:C90(145)  //CStart
					: ($_bc_lPrevTypeChar#$_bc_lTypeChar)
						$_bc_lResultIndex:=$_bc_lResultIndex+1
						$_bc_tResult[[$_bc_lResultIndex]]:=Char:C90(137)  //ShiftToC
				End case 
				
				If (($_bc_lEnd-$_bc_lStart+1)%2#0)
					_err MESSAGE(_lang Current("Code C does not contain even amout of characters, code")+ksSpace+ksQuoteSingle+$_bc_tSource+ksQuoteSingle+ksSpace+$_bc_tParamTypes+ksPeriod+ksSpace+_lang Current("Code C length is")+ksSpace+String:C10($_bc_lEnd-$_bc_lStart+1); Current method name:C684; 0)
				End if 
				$_bc_lCharIndex:=0
				For ($_bc_lSourceIndex; $_bc_lStart; $_bc_lEnd)  // loop through find str
					$_bc_lSourceAscii:=Character code:C91($_bc_tSource[[$_bc_lSourceIndex]])
					Case of 
						: ($_bc_lSourceAscii=135)  //135;á;102;FNC1
							$_bc_lResultIndex:=$_bc_lResultIndex+1
							$_bc_tResult[[$_bc_lResultIndex]]:=Char:C90($_bc_lSourceAscii)
						: (($_bc_lSourceAscii>=48) & ($_bc_lSourceAscii<=57))  // accept only numbers
							//idea of code C is to combine 2 numbers to 1 char
							$_bc_tCodeCCombined:=$_bc_tCodeCCombined+$_bc_tSource[[$_bc_lSourceIndex]]  // combine two chars to string
							If (($_bc_lCharIndex>0) | ($_bc_lSourceIndex>=$_bc_lEnd))  // two chars or last char				
								//we come here only when we have 2 chars combined or last char
								$_bc_lCodeCValue:=Num:C11($_bc_tCodeCCombined)
								Case of 
									: ($_bc_lCodeCValue<0)
										_err MESSAGE(_lang Current("Code C combined value < 0"); Current method name:C684; 0)
									: ($_bc_lCodeCValue>105)
										_err MESSAGE(_lang Current("Code C combined value > 105"); Current method name:C684; 0)
									: (($_bc_lCodeCValue+1)>Size of array:C274(<>_bc_alCode128_Ascii))
										_err MESSAGE(_lang Current("Code C combined value not found from character array"); Current method name:C684; 0)
									Else 
										$_bc_lResultIndex:=$_bc_lResultIndex+1
										$_bc_tResult[[$_bc_lResultIndex]]:=Char:C90(<>_bc_alCode128_Ascii{$_bc_lCodeCValue+1})  //0 -> arr{1}
								End case 
								$_bc_lCharIndex:=0
								$_bc_tCodeCCombined:=""
							Else 
								$_bc_lCharIndex:=$_bc_lCharIndex+1
							End if   // two chars or last char		
						Else 
							$_bc_lCharIndex:=$_bc_lCharIndex+1
							_err MESSAGE(_lang Current("Code C contains non-numeric characters"); Current method name:C684; 0)
					End case   // (accept only numbers)
				End for   // For ()
				
				
			Else 
				_err MESSAGE(_lang Current("Wrong type of code"); Current method name:C684; 0)
				$_bc_tType:=""  // set length to zero
				
		End case   // type A, B or C
		
	End if   // if (Length($_bc_tType)>0)
	$_bc_lPrevTypeChar:=$_bc_lTypeChar
	$_bc_lStart:=$_bc_lEnd+1
Until (Length:C16($_bc_tType)<=0)

// calculate check value	
$_bc_lCheckNum:=0
For ($_bc_lLoopIndex; 1; $_bc_lResultIndex)  // loop through find str
	$_bc_lSourceAscii:=Character code:C91($_bc_tResult[[$_bc_lLoopIndex]])
	If ($_bc_lLoopIndex=1)
		$_bc_lSourceIndex:=1
	Else 
		$_bc_lSourceIndex:=$_bc_lLoopIndex-1
	End if 
	Case of 
		: (($_bc_lSourceAscii>=33) & ($_bc_lSourceAscii<126))  // normal continuous ascii (! - ~), speed optimization
			$_bc_lCheckNum:=$_bc_lCheckNum+(($_bc_lSourceAscii-32)*$_bc_lSourceIndex)
		Else 
			$_bc_lCharIndex:=Find in array:C230(<>_bc_alCode128_Ascii; $_bc_lSourceAscii)
			If ($_bc_lCharIndex>0)
				$_bc_lCheckNum:=$_bc_lCheckNum+(($_bc_lCharIndex-1)*$_bc_lSourceIndex)
			Else 
				_err MESSAGE(_lang Current("Check num character not found from character array"); Current method name:C684; 0)
			End if 
	End case 
End for 

//$_bc_lCheckNum:=$_bc_lCheckNum%103 `also this works 
$_bc_lCheckNum:=Mod:C98($_bc_lCheckNum; 103)

// convert $_bc_lCheckNum to char
Case of 
	: ($_bc_lCheckNum<0)
		_err MESSAGE(_lang Current("Check num value < 0"); Current method name:C684; 0)
	: ($_bc_lCheckNum>105)
		_err MESSAGE(_lang Current("Check num value > 105"); Current method name:C684; 0)
	: (($_bc_lCheckNum+1)>Size of array:C274(<>_bc_alCode128_Ascii))
		_err MESSAGE(_lang Current("Check num value not found from character array"); Current method name:C684; 0)
	Else 
		$_bc_lResultIndex:=$_bc_lResultIndex+1
		$_bc_tResult[[$_bc_lResultIndex]]:=Char:C90(<>_bc_alCode128_Ascii{$_bc_lCheckNum+1})  //0 -> arr{1}
End case 

$_bc_lResultIndex:=$_bc_lResultIndex+1
$_bc_tResult[[$_bc_lResultIndex]]:=Char:C90(143)  //add StopChar
$_bc_lResultIndex:=$_bc_lResultIndex+1
$_bc_tResult[[$_bc_lResultIndex]]:=Char:C90(133)  // add TerminationBar

$0:=Substring:C12($_bc_tResult; 1; $_bc_lResultIndex)  //return used space of result
